<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function profile()
    {
        return $this->hasOne('App\Models\Profile', 'user_id');
    }

    public function recipes()
    {
        return $this->hasMany('App\Models\Recipes', 'id');
    }

    public function address()
    {
        return $this->hasOne('App\Models\Address', 'id');
    }

    public function invitation()
    {
        return $this->hasOne('App\Models\User', 'id');
    }

    public function followers()
    {
        return $this->hasMany('App\Models\Follower');
    }

}